/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.json;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import org.apache.logging.log4j.Logger;
import shadows.placebo.json.PlaceboJsonReloadListener;

public abstract class WeightedJsonReloadListener<V extends PlaceboJsonReloadListener.TypeKeyed<V> & ILuckyWeighted>
extends PlaceboJsonReloadListener<V> {
    protected final List<WeightedEntry.Wrapper<V>> zeroLuckList = new ArrayList<WeightedEntry.Wrapper<V>>();
    protected volatile int zeroLuckTotalWeight = 0;

    public WeightedJsonReloadListener(Logger logger, String path, boolean synced, boolean subtypes) {
        super(logger, path, synced, subtypes);
    }

    @Override
    protected void beginReload() {
        super.beginReload();
        this.zeroLuckList.clear();
        this.zeroLuckTotalWeight = 0;
    }

    @Override
    protected <T extends V> void validateItem(T item) {
        super.validateItem(item);
        Preconditions.checkArgument((((ILuckyWeighted)item).getQuality() >= 0.0f ? 1 : 0) != 0, (Object)"Item may not have negative quality!");
        Preconditions.checkArgument((((ILuckyWeighted)item).getWeight() >= 0 ? 1 : 0) != 0, (Object)"Item may not have negative weight!");
    }

    @Override
    protected <T extends V> void register(ResourceLocation key, T item) {
        super.register(key, item);
        this.zeroLuckList.add(WeightedEntry.m_146290_(item, (int)((ILuckyWeighted)item).getWeight()));
    }

    @Override
    protected void onReload() {
        super.onReload();
        this.zeroLuckTotalWeight = WeightedRandom.m_146312_(this.zeroLuckList);
        if (this.zeroLuckTotalWeight <= 0) {
            throw new RuntimeException("The total weight for the " + this.path + " manager is zero!  This is not allowed.");
        }
    }

    public V getRandomItem(Random rand) {
        return this.getRandomItem(rand, 0.0f);
    }

    public V getRandomItem(Random rand, float luck) {
        if (luck == 0.0f) {
            return (V)((PlaceboJsonReloadListener.TypeKeyed)((WeightedEntry.Wrapper)WeightedRandom.m_146320_((Random)rand, this.zeroLuckList, (int)this.zeroLuckTotalWeight).get()).m_146310_());
        }
        ArrayList list = new ArrayList(this.zeroLuckList.size());
        this.registry.values().stream().map(l -> ((ILuckyWeighted)((Object)l)).wrap(luck)).forEach(list::add);
        return (V)((PlaceboJsonReloadListener.TypeKeyed)((WeightedEntry.Wrapper)WeightedRandom.m_146317_((Random)rand, list).get()).m_146310_());
    }

    public static interface ILuckyWeighted {
        public float getQuality();

        public int getWeight();

        default public <T extends ILuckyWeighted> WeightedEntry.Wrapper<T> wrap(float luck) {
            return ILuckyWeighted.wrap(this, luck);
        }

        public static <T extends ILuckyWeighted> WeightedEntry.Wrapper<T> wrap(T item, float luck) {
            return WeightedEntry.m_146290_(item, (int)(item.getWeight() + (int)(luck * item.getQuality())));
        }
    }
}

